@extends('admin.layouts.guest')

@section('content')
<div class="w-full max-w-6xl mx-auto">
    <div class="grid lg:grid-cols-2 gap-0 items-stretch min-h-[600px]">
        
        <!-- Left Side - Branding -->
        <div class="hidden lg:flex flex-col justify-between p-12 rounded-l-2xl" style="background: linear-gradient(135deg, var(--color-primary) 0%, var(--color-secondary) 100%);">
            <div>
                <img src="{{ app_logo() }}" alt="Qansah Logo" class="h-16 w-auto mb-8 brightness-0 invert">
                <h1 class="text-4xl font-bold mb-4 text-white">
                    {{ admin_trans('welcome_back') }}
                </h1>
                <p class="text-lg text-white/90 mb-8">
                    {{ admin_trans('login_subtitle') }}
                </p>
            </div>
            
            <!-- Features List -->
            <div class="space-y-4">
                <div class="flex items-center gap-4">
                    <div class="w-12 h-12 rounded-xl bg-white/20 backdrop-blur-sm flex items-center justify-center flex-shrink-0">
                        <i data-lucide="shield-check" class="w-6 h-6 text-white"></i>
                    </div>
                    <div>
                        <h3 class="font-semibold text-white text-lg">{{ admin_trans('secure_access') }}</h3>
                        <p class="text-sm text-white/80">{{ admin_trans('protected_admin_panel') }}</p>
                    </div>
                </div>
                
                <div class="flex items-center gap-4">
                    <div class="w-12 h-12 rounded-xl bg-white/20 backdrop-blur-sm flex items-center justify-center flex-shrink-0">
                        <i data-lucide="zap" class="w-6 h-6 text-white"></i>
                    </div>
                    <div>
                        <h3 class="font-semibold text-white text-lg">{{ admin_trans('fast_control') }}</h3>
                        <p class="text-sm text-white/80">{{ admin_trans('manage_everything_quickly') }}</p>
                    </div>
                </div>
                
                <div class="flex items-center gap-4">
                    <div class="w-12 h-12 rounded-xl bg-white/20 backdrop-blur-sm flex items-center justify-center flex-shrink-0">
                        <i data-lucide="bar-chart-3" class="w-6 h-6 text-white"></i>
                    </div>
                    <div>
                        <h3 class="font-semibold text-white text-lg">{{ admin_trans('analytics') }}</h3>
                        <p class="text-sm text-white/80">{{ admin_trans('real_time_insights') }}</p>
                    </div>
                </div>
            </div>
        </div>

        <!-- Right Side - Login Form -->
        <div class="flex items-center justify-center p-8 sm:p-12 rounded-r-2xl" style="background: var(--color-bg-primary);">
            <div class="w-full max-w-md">
                
                <!-- Mobile Logo -->
                <div class="text-center mb-8 lg:hidden">
                    <img src="{{ app_logo() }}" alt="Qansah Logo" class="h-12 w-auto mx-auto mb-4">
                </div>

                <!-- Title -->
                <div class="mb-8">
                    <h2 class="text-3xl font-bold mb-2" style="color: var(--color-text-primary);">
                        {{ admin_trans('sign_in') }}
                    </h2>
                    <p class="text-sm" style="color: var(--color-text-secondary);">
                        {{ admin_trans('login_subtitle') }}
                    </p>
                </div>
                
                <!-- Success/Error Messages -->
                @if(session('success'))
                <div class="mb-6 p-4 rounded-xl flex items-start gap-3" style="background: var(--color-primary-light); border: 1px solid var(--color-primary);">
                    <i data-lucide="check-circle" class="w-5 h-5 flex-shrink-0 mt-0.5" style="color: var(--color-primary);"></i>
                    <p class="text-sm font-medium" style="color: var(--color-primary);">{{ session('success') }}</p>
                </div>
                @endif

                @if(session('error'))
                <div class="mb-6 p-4 rounded-xl flex items-start gap-3" style="background: rgba(239, 68, 68, 0.1); border: 1px solid rgba(239, 68, 68, 0.3);">
                    <i data-lucide="alert-circle" class="w-5 h-5 flex-shrink-0 mt-0.5" style="color: var(--color-danger);"></i>
                    <p class="text-sm font-medium" style="color: var(--color-danger);">{{ session('error') }}</p>
                </div>
                @endif

                <!-- Login Form -->
                <form method="POST" action="{{ route('admin.login.post') }}" class="space-y-5">
                    @csrf

                    <!-- Email Field -->
                    <div>
                        <label class="block text-sm font-semibold mb-2" style="color: var(--color-text-primary);">
                            {{ admin_trans('email') }}
                        </label>
                        <div class="relative">
                            <div class="absolute inset-y-0 flex items-center pointer-events-none {{ is_rtl() ? 'left-0 pl-3' : 'right-0 pr-3' }}">
                                <i data-lucide="mail" class="w-5 h-5" style="color: var(--color-text-tertiary);"></i>
                            </div>
                            <input
                                type="email"
                                name="email"
                                value="{{ old('email') }}"
                                class="input @error('email') !border-red-500 @enderror {{ is_rtl() ? 'pr-10' : 'pl-10' }}"
                                placeholder="{{ admin_trans('admin_email_placeholder') }}"
                                required
                                autofocus
                            >
                        </div>
                        @error('email')
                            <p class="mt-2 text-xs flex items-center gap-1.5" style="color: var(--color-danger);">
                                <i data-lucide="alert-circle" class="w-4 h-4"></i>
                                {{ $message }}
                            </p>
                        @enderror
                    </div>

                    <!-- Password Field -->
                    <div>
                        <label class="block text-sm font-semibold mb-2" style="color: var(--color-text-primary);">
                            {{ admin_trans('password') }}
                        </label>
                        <div class="relative">
                            <div class="absolute inset-y-0 flex items-center pointer-events-none {{ is_rtl() ? 'left-0 pl-3' : 'right-0 pr-3' }}">
                                <i data-lucide="lock" class="w-5 h-5" style="color: var(--color-text-tertiary);"></i>
                            </div>
                            <input 
                                type="password" 
                                name="password" 
                                class="input @error('password') !border-red-500 @enderror {{ is_rtl() ? 'pr-10' : 'pl-10' }}"
                                placeholder="••••••••"
                                required
                            >
                        </div>
                        @error('password')
                            <p class="mt-2 text-xs flex items-center gap-1.5" style="color: var(--color-danger);">
                                <i data-lucide="alert-circle" class="w-4 h-4"></i>
                                {{ $message }}
                            </p>
                        @enderror
                    </div>

                    <!-- Remember Me -->
                    <div class="flex items-center">
                        <label class="flex items-center gap-2 cursor-pointer group">
                            <input 
                                type="checkbox" 
                                name="remember" 
                                class="w-4 h-4 rounded border-2 transition-all cursor-pointer"
                                style="border-color: var(--color-border); accent-color: var(--color-primary);"
                                {{ old('remember') ? 'checked' : '' }}
                            >
                            <span class="text-sm font-medium group-hover:text-opacity-80" style="color: var(--color-text-secondary);">
                                {{ admin_trans('remember_me') }}
                            </span>
                        </label>
                    </div>

                    <!-- Submit Button -->
                    <button 
                        type="submit" 
                        class="btn btn-primary w-full justify-center text-base font-semibold py-3.5"
                    >
                        {{ admin_trans('sign_in') }}
                        <i data-lucide="arrow-right" class="w-5 h-5 {{ is_rtl() ? 'rotate-180' : '' }}"></i>
                    </button>
                </form>

                <!-- Footer -->
                <div class="text-center mt-8">
                    <p class="text-xs" style="color: var(--color-text-tertiary);">
                        {{ str_replace(':year', date('Y'), admin_trans('copyright_text')) }}
                    </p>
                </div>

            </div>
        </div>

    </div>
</div>
@endsection