@php
    $title = admin_trans('guest_users');
    $icon = 'user';
    $stats = [['label' => 'Total Guest Users', 'value' => number_format($totalGuests), 'icon' => 'user', 'color' => 'secondary']];
@endphp

@extends('admin.analytics.base')

@section('analytics-content')
@if($data->isEmpty())
    <x-empty-state icon="user" title="No guest users" />
@else
    <x-enhanced-table
        :headers="[
            'user' => ['text' => 'User', 'align' => 'auto'],
            'email' => ['text' => 'Email', 'align' => 'auto'],
            'joined' => ['text' => 'Joined', 'align' => 'center']
        ]"
        :responsive="true"
    >
        @foreach($data as $user)
        <tr>
            <x-table-cell type="text"><span class="font-medium text-primary">{{ $user->name }}</span></x-table-cell>
            <x-table-cell type="text"><span class="text-secondary">{{ $user->email }}</span></x-table-cell>
            <x-table-cell type="center"><span class="text-sm text-tertiary">{{ $user->created_at->format('Y-m-d') }}</span></x-table-cell>
        </tr>
        @endforeach
    </x-enhanced-table>
    @if($data->hasPages())
        <div class="mt-4"><x-pagination :paginator="$data" /></div>
    @endif
@endif
@endsection
