@php
    $title = admin_trans('users_by_language');
    $icon = 'languages';
@endphp

@extends('admin.analytics.base')

@section('analytics-content')
@if($data->isEmpty())
    <x-empty-state icon="languages" :title="admin_trans('no_data')" />
@else
    <x-enhanced-table
        :headers="['language' => ['text' => 'Language', 'align' => 'auto'], 'total' => ['text' => 'Total Users', 'align' => 'center']]"
        :responsive="true"
    >
        @foreach($data as $item)
        <tr>
            <x-table-cell type="text">
                <div>
                    <div class="font-medium text-primary">{{ $item->language_name ?? 'Unknown' }}</div>
                    <div class="text-sm text-tertiary">{{ $item->native_name }}</div>
                </div>
            </x-table-cell>
            <x-table-cell type="center"><span class="text-lg font-bold text-primary">{{ number_format($item->total) }}</span></x-table-cell>
        </tr>
        @endforeach
    </x-enhanced-table>
@endif
@endsection
