@php
    $title = admin_trans('banned_users');
    $icon = 'user-x';
    $stats = [['label' => 'Total Banned Users', 'value' => number_format($totalBanned), 'icon' => 'user-x', 'color' => 'danger']];
@endphp

@extends('admin.analytics.base')

@section('analytics-content')
@if($data->isEmpty())
    <x-empty-state icon="user-x" title="No banned users" />
@else
    <x-enhanced-table
        :headers="[
            'user' => ['text' => 'User', 'align' => 'auto'],
            'email' => ['text' => 'Email', 'align' => 'auto'],
            'role' => ['text' => 'Role', 'align' => 'center'],
            'banned_at' => ['text' => 'Banned At', 'align' => 'center']
        ]"
        :responsive="true"
    >
        @foreach($data as $user)
        <tr>
            <x-table-cell type="text"><span class="font-medium text-danger-500">{{ $user->name }}</span></x-table-cell>
            <x-table-cell type="text"><span class="text-secondary">{{ $user->email }}</span></x-table-cell>
            <x-table-cell type="center"><x-badge variant="danger">{{ ucfirst($user->role) }}</x-badge></x-table-cell>
            <x-table-cell type="center"><span class="text-sm text-tertiary">{{ $user->updated_at->format('Y-m-d') }}</span></x-table-cell>
        </tr>
        @endforeach
    </x-enhanced-table>
    @if($data->hasPages())
        <div class="mt-4"><x-pagination :paginator="$data" /></div>
    @endif
@endif
@endsection
