@php
    $title = admin_trans('active_users');
    $icon = 'user-check';
    $stats = [['label' => 'Total Active Users', 'value' => number_format($totalActive), 'icon' => 'user-check', 'color' => 'success']];
@endphp

@extends('admin.analytics.base')

@section('analytics-content')
@if($data->isEmpty())
    <x-empty-state icon="user-check" title="No active users" />
@else
    <x-enhanced-table
        :headers="[
            'user' => ['text' => 'User', 'align' => 'auto'],
            'email' => ['text' => 'Email', 'align' => 'auto'],
            'role' => ['text' => 'Role', 'align' => 'center'],
            'joined' => ['text' => 'Joined', 'align' => 'center']
        ]"
        :responsive="true"
    >
        @foreach($data as $user)
        <tr>
            <x-table-cell type="text"><span class="font-medium text-primary">{{ $user->name }}</span></x-table-cell>
            <x-table-cell type="text"><span class="text-secondary">{{ $user->email }}</span></x-table-cell>
            <x-table-cell type="center"><x-badge variant="primary">{{ ucfirst($user->role) }}</x-badge></x-table-cell>
            <x-table-cell type="center"><span class="text-sm text-tertiary">{{ $user->created_at->format('Y-m-d') }}</span></x-table-cell>
        </tr>
        @endforeach
    </x-enhanced-table>
    @if($data->hasPages())
        <div class="mt-4"><x-pagination :paginator="$data" /></div>
    @endif
@endif
@endsection
