@php
    $title = admin_trans('store_performance_report');
    $icon = 'activity';
    $stats = [
        ['label' => 'Total Stores', 'value' => number_format($totalStores), 'icon' => 'store', 'color' => 'primary'],
        ['label' => 'Active Stores', 'value' => number_format($activeStores), 'icon' => 'check-circle', 'color' => 'success'],
        ['label' => 'Featured Stores', 'value' => number_format($featuredStores), 'icon' => 'star', 'color' => 'warning'],
        ['label' => 'Total Followers', 'value' => number_format($totalFollowers), 'icon' => 'users', 'color' => 'secondary']
    ];
@endphp

@extends('admin.analytics.base')

@section('analytics-content')
<div class="space-y-6">
    <div>
        <h3 class="text-lg font-bold text-primary mb-4">Top Stores by Followers</h3>
        <x-enhanced-table
            :headers="['store' => ['text' => 'Store', 'align' => 'auto'], 'followers' => ['text' => 'Followers', 'align' => 'center'], 'offers' => ['text' => 'Offers', 'align' => 'center']]"
            :responsive="true"
        >
            @foreach($topStores as $store)
            <tr>
                <x-table-cell type="text"><span class="font-medium text-primary">{{ $store->name }}</span></x-table-cell>
                <x-table-cell type="center"><span class="font-bold text-primary">{{ number_format($store->followers_count ?? 0) }}</span></x-table-cell>
                <x-table-cell type="center"><x-badge variant="secondary">{{ number_format($store->offers_count ?? 0) }}</x-badge></x-table-cell>
            </tr>
            @endforeach
        </x-enhanced-table>
    </div>

    <div>
        <h3 class="text-lg font-bold text-primary mb-4">Stores by Country</h3>
        <x-enhanced-table
            :headers="['country' => ['text' => 'Country', 'align' => 'auto'], 'stores' => ['text' => 'Stores', 'align' => 'center']]"
            :responsive="true"
        >
            @foreach($storesByCountry as $item)
            <tr>
                <x-table-cell type="text">
                    <div class="flex items-center gap-2">
                        <span class="text-2xl">{{ $item->flag_emoji ?? '🌍' }}</span>
                        <span class="font-medium text-primary">{{ $item->country_name }}</span>
                    </div>
                </x-table-cell>
                <x-table-cell type="center"><x-badge variant="primary">{{ number_format($item->total) }}</x-badge></x-table-cell>
            </tr>
            @endforeach
        </x-enhanced-table>
    </div>
</div>
@endsection
