@php
    $title = admin_trans('stores_by_offers_count');
    $icon = 'tag';
@endphp

@extends('admin.analytics.base')

@section('analytics-content')
@if($data->isEmpty())
    <x-empty-state icon="tag" :title="admin_trans('no_data')" />
@else
    <x-enhanced-table
        :headers="[
            'store' => ['text' => 'Store', 'align' => 'auto'],
            'country' => ['text' => 'Country', 'align' => 'center'],
            'offers' => ['text' => 'Offers Count', 'align' => 'center']
        ]"
        :responsive="true"
    >
        @foreach($data as $store)
        <tr>
            <x-table-cell type="text"><span class="font-medium text-primary">{{ $store->name }}</span></x-table-cell>
            <x-table-cell type="center">{{ $store->country_name ?? 'N/A' }}</x-table-cell>
            <x-table-cell type="center"><x-badge variant="primary">{{ number_format($store->offers_count ?? 0) }}</x-badge></x-table-cell>
        </tr>
        @endforeach
    </x-enhanced-table>
    @if($data->hasPages())
        <div class="mt-4"><x-pagination :paginator="$data" /></div>
    @endif
@endif
@endsection
