@php
    $title = admin_trans('stores_by_followers');
    $icon = 'users';
@endphp

@extends('admin.analytics.base')

@section('analytics-content')
@if($data->isEmpty())
    <x-empty-state icon="users" :title="admin_trans('no_data')" />
@else
    <x-enhanced-table
        :headers="[
            'store' => ['text' => 'Store', 'align' => 'auto'],
            'country' => ['text' => 'Country', 'align' => 'center'],
            'followers' => ['text' => 'Followers', 'align' => 'center']
        ]"
        :responsive="true"
    >
        @foreach($data as $store)
        <tr>
            <x-table-cell type="text"><span class="font-medium text-primary">{{ $store->name }}</span></x-table-cell>
            <x-table-cell type="center">{{ $store->country_name ?? 'N/A' }}</x-table-cell>
            <x-table-cell type="center"><span class="text-lg font-bold text-primary">{{ number_format($store->followers_count ?? 0) }}</span></x-table-cell>
        </tr>
        @endforeach
    </x-enhanced-table>
    @if($data->hasPages())
        <div class="mt-4"><x-pagination :paginator="$data" /></div>
    @endif
@endif
@endsection
