@php
    $title = admin_trans('stores_by_country');
    $description = 'View stores distribution across different countries';
    $icon = 'globe';
@endphp

@extends('admin.analytics.base')

@section('analytics-content')

@if($data->isEmpty())
    <x-empty-state
        icon="globe"
        :title="admin_trans('no_data')"
        description="No stores data available yet"
    />
@else
    <!-- Chart Section -->
    <div class="mb-6">
        <canvas id="countryChart" height="100"></canvas>
    </div>

    <!-- Data Table -->
    <x-enhanced-table
        :headers="[
            'country' => [
                'text' => admin_trans('country'),
                'align' => 'auto',
            ],
            'total' => [
                'text' => admin_trans('total'),
                'align' => 'center',
            ],
            'percentage' => [
                'text' => 'Percentage',
                'align' => 'center',
            ]
        ]"
        :responsive="true"
    >
        @php
            $total = $data->sum('total');
        @endphp
        @foreach($data as $item)
        <tr class="hover:bg-primary-light transition-colors">
            <x-table-cell type="text">
                <div class="flex items-center gap-3">
                    <span class="text-2xl">{{ $item->flag_emoji ?? '🌍' }}</span>
                    <span class="font-medium text-primary">{{ $item->country_name }}</span>
                </div>
            </x-table-cell>
            <x-table-cell type="center">
                <span class="text-lg font-bold text-primary">{{ number_format($item->total) }}</span>
            </x-table-cell>
            <x-table-cell type="center">
                <div class="w-full max-w-xs">
                    <div class="flex items-center gap-2">
                        <div class="flex-1 bg-gray-200 rounded-full h-2">
                            <div class="h-2 rounded-full" style="width: {{ $total > 0 ? round(($item->total / $total) * 100, 1) : 0 }}%; background: var(--color-primary);"></div>
                        </div>
                        <span class="text-sm text-secondary min-w-[50px] text-right">{{ $total > 0 ? round(($item->total / $total) * 100, 1) : 0 }}%</span>
                    </div>
                </div>
            </x-table-cell>
        </tr>
        @endforeach
    </x-enhanced-table>
@endif

@endsection

@if(!$data->isEmpty())
@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/chart.js@4"></script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    const ctx = document.getElementById('countryChart').getContext('2d');

    const data = @json($data);
    const labels = data.map(item => item.country_name);
    const values = data.map(item => item.total);

    new Chart(ctx, {
        type: 'bar',
        data: {
            labels: labels,
            datasets: [{
                label: 'Number of Stores',
                data: values,
                backgroundColor: 'rgba(22, 204, 98, 0.8)',
                borderColor: 'rgba(22, 204, 98, 1)',
                borderWidth: 2,
                borderRadius: 8,
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: true,
            plugins: {
                legend: {
                    display: false
                },
                title: {
                    display: true,
                    text: 'Stores by Country'
                }
            },
            scales: {
                y: {
                    beginAtZero: true,
                    ticks: {
                        precision: 0
                    }
                }
            }
        }
    });
});
</script>
@endpush
@endif
