@php
    $title = admin_trans('offers_usage_report');
    $icon = 'file-text';
    $stats = [
        ['label' => 'Total Offers', 'value' => number_format($totalOffers), 'icon' => 'tag', 'color' => 'primary'],
        ['label' => 'Active Offers', 'value' => number_format($activeOffers), 'icon' => 'check-circle', 'color' => 'success'],
        ['label' => 'Expired Offers', 'value' => number_format($expiredOffers), 'icon' => 'x-circle', 'color' => 'danger'],
        ['label' => 'Total Views', 'value' => number_format($totalViews), 'icon' => 'eye', 'color' => 'secondary']
    ];
@endphp

@extends('admin.analytics.base')

@section('analytics-content')
<div>
    <h3 class="text-lg font-bold text-primary mb-4">Top Stores by Offers Count</h3>
    <x-enhanced-table
        :headers="['store' => ['text' => 'Store', 'align' => 'auto'], 'offers' => ['text' => 'Offers', 'align' => 'center']]"
        :responsive="true"
    >
        @foreach($topStores as $store)
        <tr>
            <x-table-cell type="text"><span class="font-medium text-primary">{{ $store->name }}</span></x-table-cell>
            <x-table-cell type="center"><x-badge variant="primary">{{ number_format($store->offers_count ?? 0) }}</x-badge></x-table-cell>
        </tr>
        @endforeach
    </x-enhanced-table>
</div>
@endsection
