@php
    $title = admin_trans('least_popular_offers');
    $icon = 'trending-down';
@endphp

@extends('admin.analytics.base')

@section('analytics-content')
@if($data->isEmpty())
    <x-empty-state icon="trending-down" :title="admin_trans('no_data')" />
@else
    <x-enhanced-table
        :headers="[
            'offer' => ['text' => 'Offer', 'align' => 'auto'],
            'store' => ['text' => 'Store', 'align' => 'center'],
            'views' => ['text' => 'Views', 'align' => 'center'],
            'clicks' => ['text' => 'Clicks', 'align' => 'center']
        ]"
        :responsive="true"
    >
        @foreach($data as $offer)
        @php
            $offerTitle = $offer->translations->first()?->title ?? "Offer #{$offer->id}";
            $storeName = $offer->countryStore?->store?->translations->first()?->name ?? "Store #" . ($offer->countryStore?->store_id ?? 'N/A');
        @endphp
        <tr>
            <x-table-cell type="text"><span class="font-medium text-primary">{{ $offerTitle }}</span></x-table-cell>
            <x-table-cell type="center">{{ $storeName }}</x-table-cell>
            <x-table-cell type="center"><span class="text-tertiary">{{ number_format($offer->views_count ?? 0) }}</span></x-table-cell>
            <x-table-cell type="center"><span class="text-tertiary">{{ number_format($offer->uses_count ?? 0) }}</span></x-table-cell>
        </tr>
        @endforeach
    </x-enhanced-table>
    @if($data->hasPages())
        <div class="mt-4"><x-pagination :paginator="$data" /></div>
    @endif
@endif
@endsection
