@php
    $title = admin_trans('offers_expiring_soon');
    $description = 'Offers expiring within the next 7 days';
    $icon = 'clock';
@endphp

@extends('admin.analytics.base')

@section('analytics-content')
@if($data->isEmpty())
    <x-empty-state icon="clock" title="No expiring offers" description="All offers are valid for more than 7 days" />
@else
    <x-enhanced-table
        :headers="[
            'offer' => ['text' => 'Offer', 'align' => 'auto'],
            'store' => ['text' => 'Store', 'align' => 'center'],
            'end_date' => ['text' => 'Expires On', 'align' => 'center'],
            'days_left' => ['text' => 'Days Left', 'align' => 'center']
        ]"
        :responsive="true"
    >
        @foreach($data as $offer)
        @php
            $offerTitle = $offer->translations->first()?->title ?? "Offer #{$offer->id}";
            $storeName = $offer->countryStore?->store?->translations->first()?->name ?? "Store #" . ($offer->countryStore?->store_id ?? 'N/A');
        @endphp
        <tr>
            <x-table-cell type="text"><span class="font-medium text-primary">{{ $offerTitle }}</span></x-table-cell>
            <x-table-cell type="center">{{ $storeName }}</x-table-cell>
            <x-table-cell type="center">{{ $offer->expires_at->format('Y-m-d') }}</x-table-cell>
            <x-table-cell type="center">
                @php $daysLeft = now()->diffInDays($offer->expires_at, false); @endphp
                <x-badge variant="{{ $daysLeft <= 1 ? 'danger' : ($daysLeft <= 3 ? 'warning' : 'secondary') }}">
                    {{ max(0, ceil($daysLeft)) }} {{ max(0, ceil($daysLeft)) == 1 ? 'day' : 'days' }}
                </x-badge>
            </x-table-cell>
        </tr>
        @endforeach
    </x-enhanced-table>
    @if($data->hasPages())
        <div class="mt-4"><x-pagination :paginator="$data" /></div>
    @endif
@endif
@endsection
