@php
    $title = admin_trans('offers_by_type');
    $description = 'View offers grouped by type (discount, coupon, deal, etc.)';
    $icon = 'layers';
@endphp

@extends('admin.analytics.base')

@section('analytics-content')
@if($data->isEmpty())
    <x-empty-state icon="layers" :title="admin_trans('no_data')" />
@else
    <x-enhanced-table
        :headers="['type' => ['text' => 'Type', 'align' => 'auto'], 'total' => ['text' => 'Total', 'align' => 'center']]"
        :responsive="true"
    >
        @foreach($data as $item)
        <tr>
            <x-table-cell type="text"><x-badge variant="primary">{{ ucfirst($item->type) }}</x-badge></x-table-cell>
            <x-table-cell type="center"><span class="text-lg font-bold text-primary">{{ number_format($item->total) }}</span></x-table-cell>
        </tr>
        @endforeach
    </x-enhanced-table>
@endif
@endsection
