@php
    $title = admin_trans('offers_by_status');
    $description = 'View offers grouped by their current status';
    $icon = 'tag';
@endphp

@extends('admin.analytics.base')

@section('analytics-content')

@if($data->isEmpty())
    <x-empty-state
        icon="tag"
        :title="admin_trans('no_data')"
        description="No offers data available yet"
    />
@else
    <!-- Chart Section -->
    <div class="mb-6">
        <canvas id="statusChart" height="80"></canvas>
    </div>

    <!-- Data Table -->
    <x-enhanced-table
        :headers="[
            'status' => [
                'text' => admin_trans('status'),
                'align' => 'auto',
            ],
            'total' => [
                'text' => admin_trans('total'),
                'align' => 'center',
            ],
            'percentage' => [
                'text' => 'Percentage',
                'align' => 'center',
            ]
        ]"
        :responsive="true"
    >
        @php
            $total = $data->sum('total');
        @endphp
        @foreach($data as $item)
        <tr class="hover:bg-primary-light transition-colors">
            <x-table-cell type="text">
                <x-badge variant="{{ $item->status === 'active' ? 'success' : ($item->status === 'draft' ? 'warning' : 'secondary') }}">
                    {{ ucfirst($item->status) }}
                </x-badge>
            </x-table-cell>
            <x-table-cell type="center">
                <span class="text-lg font-bold text-primary">{{ number_format($item->total) }}</span>
            </x-table-cell>
            <x-table-cell type="center">
                <span class="text-sm text-secondary">{{ $total > 0 ? round(($item->total / $total) * 100, 1) : 0 }}%</span>
            </x-table-cell>
        </tr>
        @endforeach
    </x-enhanced-table>
@endif

@endsection

@if(!$data->isEmpty())
@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/chart.js@4"></script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    const ctx = document.getElementById('statusChart').getContext('2d');

    const data = @json($data);
    const labels = data.map(item => item.status.charAt(0).toUpperCase() + item.status.slice(1));
    const values = data.map(item => item.total);

    const colors = {
        'active': '#16CC62',
        'draft': '#F59E0B',
        'expired': '#94A3B8',
        'pending': '#3B82F6'
    };

    const backgroundColors = data.map(item => colors[item.status] || '#94A3B8');

    new Chart(ctx, {
        type: 'doughnut',
        data: {
            labels: labels,
            datasets: [{
                data: values,
                backgroundColor: backgroundColors,
                borderWidth: 0,
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: true,
            plugins: {
                legend: {
                    position: 'bottom',
                },
                title: {
                    display: true,
                    text: 'Offers by Status Distribution'
                }
            }
        }
    });
});
</script>
@endpush
@endif
