@php
    $title = admin_trans('offers_by_brand');
    $icon = 'sparkles';
@endphp

@extends('admin.analytics.base')

@section('analytics-content')
@if($data->isEmpty())
    <x-empty-state icon="sparkles" :title="admin_trans('no_data')" />
@else
    <x-enhanced-table
        :headers="['brand' => ['text' => 'Brand', 'align' => 'auto'], 'offers' => ['text' => 'Offers Count', 'align' => 'center']]"
        :responsive="true"
    >
        @foreach($data as $item)
        <tr>
            <x-table-cell type="text"><span class="font-medium text-primary">{{ $item->brand_name ?? 'N/A' }}</span></x-table-cell>
            <x-table-cell type="center"><span class="text-lg font-bold text-primary">{{ number_format($item->total) }}</span></x-table-cell>
        </tr>
        @endforeach
    </x-enhanced-table>

    @if($data->hasPages())
        <div class="mt-4"><x-pagination :paginator="$data" /></div>
    @endif
@endif
@endsection
