@extends('admin.layouts.app')

@section('title', $title ?? admin_trans('analytics'))
@section('page-title', $title ?? admin_trans('analytics'))

@section('content')

<div class="space-y-6">

    <!-- Page Header with Icon -->
    <div class="card">
        <div class="flex items-center gap-4">
            <div class="w-14 h-14 rounded-xl flex items-center justify-center gradient-primary">
                <i data-lucide="{{ $icon ?? 'bar-chart-3' }}" class="w-7 h-7 text-white"></i>
            </div>
            <div class="flex-1">
                <h1 class="text-2xl font-bold text-primary">{{ $title }}</h1>
                @if(isset($description))
                    <p class="text-sm text-secondary mt-1">{{ $description }}</p>
                @endif
            </div>
            @if(isset($headerActions))
                <div class="flex items-center gap-3">
                    {!! $headerActions !!}
                </div>
            @endif
        </div>
    </div>

    <!-- Stats Cards (if provided) -->
    @if(isset($stats) && count($stats) > 0)
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
            @foreach($stats as $stat)
                <div class="card">
                    <div class="flex items-center justify-between">
                        <div>
                            <p class="text-sm text-tertiary">{{ $stat['label'] }}</p>
                            <h3 class="text-2xl font-bold text-primary mt-1">{{ $stat['value'] }}</h3>
                            @if(isset($stat['change']))
                                <p class="text-xs {{ $stat['change'] >= 0 ? 'text-success-500' : 'text-danger-500' }} mt-1">
                                    {{ $stat['change'] >= 0 ? '+' : '' }}{{ $stat['change'] }}%
                                </p>
                            @endif
                        </div>
                        @if(isset($stat['icon']))
                            <div class="w-12 h-12 rounded-lg flex items-center justify-center" style="background: var(--color-{{ $stat['color'] ?? 'primary' }}-light);">
                                <i data-lucide="{{ $stat['icon'] }}" class="w-6 h-6" style="color: var(--color-{{ $stat['color'] ?? 'primary' }});"></i>
                            </div>
                        @endif
                    </div>
                </div>
            @endforeach
        </div>
    @endif

    <!-- Main Content -->
    <div class="card">
        @yield('analytics-content')
    </div>

</div>

@endsection
