<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class LocaleResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'code' => $this->code,
            'name' => $this->name,
            'is_default' => $this->is_default,
            'status' => $this->status,
            
            // Relationships
            'country' => new CountryResource($this->whenLoaded('country')),
            'language' => new LanguageResource($this->whenLoaded('language')),
        ];
    }
}