<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\ResourceCollection;

class BaseResourceCollection extends ResourceCollection
{
    /**
     * Transform the resource collection into an array.
     *
     * @return array<int|string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'data' => $this->collection,
            'pagination' => $this->when($this->resource instanceof \Illuminate\Pagination\LengthAwarePaginator, [
                'current_page' => $this->currentPage(),
                'last_page' => $this->lastPage(),
                'per_page' => $this->perPage(),
                'total' => $this->total(),
                'from' => $this->firstItem(),
                'to' => $this->lastItem(),
                'has_more_pages' => $this->hasMorePages(),
            ]),
        ];
    }

    /**
     * Get additional data that should be returned with the resource array.
     *
     * @return array<string, mixed>
     */
    public function with(Request $request): array
    {
        return [
            'success' => true,
            'message' => $this->message ?? 'Data retrieved successfully',
        ];
    }

    /**
     * Set custom message for the response
     */
    public function setMessage(string $message): self
    {
        $this->message = $message;
        return $this;
    }
}

class CategoryCollection extends BaseResourceCollection
{
    //
}

class StoreCollection extends BaseResourceCollection 
{
    //
}

class BrandCollection extends BaseResourceCollection
{
    //
}

class OfferCollection extends BaseResourceCollection
{
    //
}