<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class StoreTranslation extends Model
{
    use HasFactory;

    protected $fillable = [
        'store_id',
        'locale_id',
        'name',
        'description',
        'home_url',
        'final_url',
    ];

    // Relations
    public function store()
    {
        return $this->belongsTo(Store::class);
    }

    public function locale()
    {
        return $this->belongsTo(Locale::class);
    }

    // Scopes
    public function scopeByLocale($query, $localeId)
    {
        return $query->where('locale_id', $localeId);
    }

    public function scopeByStore($query, $storeId)
    {
        return $query->where('store_id', $storeId);
    }
}