<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Page extends Model
{
    use HasFactory;

    protected $fillable = [
        'status',
    ];

    // Relations
    public function translations()
    {
        return $this->hasMany(PageTranslation::class);
    }

    // Scopes
    public function scopeActive($query)
    {
        return $query->where('status', 'active');
    }

    public function scopePublished($query)
    {
        return $query->where('status', 'published');
    }

    public function scopeDraft($query)
    {
        return $query->where('status', 'draft');
    }

    // Helper Methods
    public function getTranslation($localeId)
    {
        return $this->translations()->where('locale_id', $localeId)->first();
    }

    public function getTitle($localeId = null)
    {
        if ($localeId) {
            $translation = $this->getTranslation($localeId);
            return $translation ? $translation->title : 'Page #' . $this->id;
        }
        return 'Page #' . $this->id;
    }

    public function getDescription($localeId = null)
    {
        if ($localeId) {
            $translation = $this->getTranslation($localeId);
            return $translation ? $translation->description : null;
        }
        return null;
    }

    // Accessors
    public function getIsActiveAttribute()
    {
        return $this->status === 'active' || $this->status === 'published';
    }
}