<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class OfferTranslation extends Model
{
    use HasFactory;

    protected $fillable = [
        'offer_id',
        'locale_id',
        'title',
        'description',
        'final_url',
    ];

    // Relations
    public function offer()
    {
        return $this->belongsTo(Offer::class);
    }

    public function locale()
    {
        return $this->belongsTo(Locale::class);
    }

    // Scopes
    public function scopeByLocale($query, $localeId)
    {
        return $query->where('locale_id', $localeId);
    }

    public function scopeByOffer($query, $offerId)
    {
        return $query->where('offer_id', $offerId);
    }
}   