<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class OccasionTranslation extends Model
{
    use HasFactory;

    protected $fillable = [
        'occasion_id',
        'locale_id',
        'name',
        'description',
    ];

    // Relations
    public function occasion()
    {
        return $this->belongsTo(Occasion::class);
    }

    public function locale()
    {
        return $this->belongsTo(Locale::class);
    }

    // Scopes
    public function scopeByLocale($query, $localeId)
    {
        return $query->where('locale_id', $localeId);
    }

    public function scopeByOccasion($query, $occasionId)
    {
        return $query->where('occasion_id', $occasionId);
    }
}
