<?php

if (!function_exists('flash_success')) {
    /**
     * Flash success message
     * 
     * @param string $message
     * @param string|null $title
     * @return \Illuminate\Http\RedirectResponse|null
     */
    function flash_success(string $message, ?string $title = null)
    {
        session()->flash('toast', [
            'type' => 'success',
            'message' => $message,
            'title' => $title ?? admin_trans('success'),
        ]);

        return null;
    }
}

if (!function_exists('flash_error')) {
    /**
     * Flash error message
     * 
     * @param string $message
     * @param string|null $title
     * @return \Illuminate\Http\RedirectResponse|null
     */
    function flash_error(string $message, ?string $title = null)
    {
        session()->flash('toast', [
            'type' => 'error',
            'message' => $message,
            'title' => $title ?? admin_trans('error'),
        ]);

        return null;
    }
}

if (!function_exists('flash_warning')) {
    /**
     * Flash warning message
     * 
     * @param string $message
     * @param string|null $title
     * @return \Illuminate\Http\RedirectResponse|null
     */
    function flash_warning(string $message, ?string $title = null)
    {
        session()->flash('toast', [
            'type' => 'warning',
            'message' => $message,
            'title' => $title ?? admin_trans('warning'),
        ]);

        return null;
    }
}

if (!function_exists('flash_info')) {
    /**
     * Flash info message
     * 
     * @param string $message
     * @param string|null $title
     * @return \Illuminate\Http\RedirectResponse|null
     */
    function flash_info(string $message, ?string $title = null)
    {
        session()->flash('toast', [
            'type' => 'info',
            'message' => $message,
            'title' => $title ?? admin_trans('info'),
        ]);

        return null;
    }
}

