<?php

if (!function_exists('current_filtered_country')) {
    /**
     * Get the currently selected country for filtering
     * 
     * @return \App\Models\Country|null
     */
    function current_filtered_country()
    {
        $countryId = session('admin_country_filter');
        
        if ($countryId) {
            return \App\Models\Country::find($countryId);
        }
        
        // Return default country if no filter set
        return \App\Models\Country::where('is_default', true)->first();
    }
}

if (!function_exists('current_filtered_country_id')) {
    /**
     * Get the currently selected country ID for filtering
     * 
     * @return int|null
     */
    function current_filtered_country_id()
    {
        $country = current_filtered_country();
        return $country ? $country->id : null;
    }
}

if (!function_exists('set_country_filter')) {
    /**
     * Set the country filter
     * 
     * @param int $countryId
     * @return void
     */
    function set_country_filter($countryId)
    {
        session(['admin_country_filter' => $countryId]);
    }
}

if (!function_exists('clear_country_filter')) {
    /**
     * Clear the country filter
     * 
     * @return void
     */
    function clear_country_filter()
    {
        session()->forget('admin_country_filter');
    }
}

if (!function_exists('get_available_countries_for_filter')) {
    /**
     * Get all available countries for filtering
     * 
     * @return \Illuminate\Database\Eloquent\Collection
     */
    function get_available_countries_for_filter()
    {
        return \App\Models\Country::active()->ordered()->get();
    }
}